/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdkplugin.dirbrowser;

import java.util.Vector;
import javax.swing.table.AbstractTableModel;
import org.openscience.cdk.ChemModel;
import org.openscience.cdk.internet.DADMLResult;

class ResultsContentModel
extends AbstractTableModel {
    private Vector models;
    final String[] columnNames = new String[]{"name", "source", "type", "mime", "url"};

    public ResultsContentModel() {
        this.models = new Vector();
    }

    public void setValueAt(Object value, int row, int column) {
    }

    public void setValueAt(ChemModel model, int row) {
        if (row > this.getRowCount()) {
            return;
        }
        this.models.setElementAt(model, row);
        this.fireTableCellUpdated(row, 1);
    }

    public int getColumnCount() {
        return this.columnNames.length;
    }

    public int getRowCount() {
        return this.models.size();
    }

    public String getColumnName(int col) {
        return this.columnNames[col];
    }

    public Class getColumnClass(int col) {
        Object o = this.getValueAt(0, col);
        if (o == null) {
            return new String().getClass();
        }
        return o.getClass();
    }

    public Object getValueAt(int row, int column) {
        if (row > this.getRowCount() - 1 || column > this.getColumnCount() - 1) {
            return "Error";
        }
        ChemModel model = (ChemModel)this.models.elementAt(row);
        if (model == null) {
            return "";
        }
        DADMLResult resource = (DADMLResult)model.getProperty((Object)"org.openscience.cdk.internet.DADMLResult");
        if (resource == null) {
            return "";
        }
        if (column == 0) {
            return resource.getField().getNAME();
        }
        if (column == 1) {
            return resource.getField().getSOURCE();
        }
        if (column == 2) {
            return resource.getField().getTYPE();
        }
        if (column == 3) {
            return resource.getField().getMIMETYPE();
        }
        if (column == 4) {
            return resource.getURL().toString();
        }
        return "";
    }

    public ChemModel getValueAt(int row) {
        return (ChemModel)this.models.elementAt(row);
    }

    public boolean isCellEditable(int row, int col) {
        return false;
    }

    public void cleanTable() {
        this.models.clear();
        this.fireTableDataChanged();
    }

    private void insertBlankRow(int row) {
        this.models.addElement(null);
        this.fireTableRowsInserted(row + 1, row + 1);
    }

    public void addChemModel(ChemModel model) {
        int lastLine = this.getRowCount();
        this.insertBlankRow(lastLine);
        this.setValueAt(model, lastLine);
    }
}

