/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.internet;

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.util.Enumeration;
import java.util.Vector;
import org.openscience.cdk.ChemFile;
import org.openscience.cdk.ChemModel;
import org.openscience.cdk.ChemObject;
import org.openscience.cdk.ChemSequence;
import org.openscience.cdk.Molecule;
import org.openscience.cdk.SetOfMolecules;
import org.openscience.cdk.exception.CDKException;
import org.openscience.cdk.exception.UnsupportedChemObjectException;
import org.openscience.cdk.internet.DADMLResult;
import org.openscience.cdk.io.ChemObjectReader;
import org.openscience.cdk.io.ReaderFactory;
import org.openscience.cdk.io.formats.ChemFormat;
import org.openscience.cdk.tools.LoggingTool;
import org.openscience.dadml.DATABASE;
import org.openscience.dadml.DBDEF;
import org.openscience.dadml.DBLIST;
import org.openscience.dadml.FIELD;
import org.openscience.dadml.INDEX;
import org.openscience.dadml.filereaders.DBDEFFileReader;
import org.openscience.dadml.filereaders.DBLISTFileReader;
import org.openscience.dadml.tools.DBDEFInfo;

public class DADMLReader {
    private String superdb;
    private LoggingTool logger = new LoggingTool((Object)this);
    private URI query;

    public DADMLReader(String superdb) {
        this.superdb = superdb;
        this.query = null;
    }

    public ChemFormat getFormat() {
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    public void setReader(Reader input) throws CDKException {
        throw new CDKException("This Reader does not read from a Reader but from internet nodes");
    }

    public void setQuery(String indexType, String value) {
        try {
            this.query = new URI("dadml://any/" + indexType + "?" + value);
        }
        catch (URISyntaxException exception) {
            this.logger.error((Object)"Serious error: ", (Object)exception.getMessage());
            this.logger.debug((Object)exception);
        }
    }

    public void setQuery(URI query) throws URISyntaxException {
        this.query = query;
    }

    public ChemObject read(ChemObject object) throws UnsupportedChemObjectException {
        if (object instanceof Molecule) {
            return this.readMolecule();
        }
        throw new UnsupportedChemObjectException("Only supported is Molecule.");
    }

    private Molecule readMolecule() {
        Molecule molecule = null;
        try {
            URL resource = this.resolveLink(this.query);
            molecule = this.downloadURL(resource);
        }
        catch (Exception exception) {
            this.logger.error((Object)"File Not Found: ", (Object)exception.getMessage());
            this.logger.debug((Object)exception);
        }
        return molecule;
    }

    public URL resolveLink(URI dadmlRI) {
        Vector links = this.resolveLinks(dadmlRI);
        if (links.size() > 0) {
            return ((DADMLResult)links.elementAt(0)).getURL();
        }
        return null;
    }

    public Vector resolveLinks(URI dadmlRI) {
        this.logger.debug((Object)"Resolving URI: ", (Object)dadmlRI);
        Vector<DADMLResult> links = new Vector<DADMLResult>();
        boolean found = false;
        boolean done = false;
        String indexType = dadmlRI.getPath().substring(1);
        String index = dadmlRI.getQuery();
        Molecule molecule = new Molecule();
        DBLIST dblist = new DBLIST();
        try {
            this.logger.info((Object)"Downloading DADML super database: ", (Object)this.superdb);
            DBLISTFileReader reader = new DBLISTFileReader();
            dblist = reader.read(this.superdb);
        }
        catch (Exception supererror) {
            this.logger.error((Object)"Exception while reading super db: ", (Object)supererror.getMessage());
            this.logger.debug((Object)supererror);
        }
        Enumeration dbases = dblist.databases();
        while (!found && !done && dbases.hasMoreElements()) {
            DATABASE database = (DATABASE)dbases.nextElement();
            String dburl = database.getURL() + database.getDefinition();
            DBDEF dbdef = new DBDEF();
            try {
                this.logger.info((Object)"Downloading: ", (Object)dburl);
                DBDEFFileReader reader = new DBDEFFileReader();
                dbdef = reader.read(dburl);
            }
            catch (Exception deferror) {
                System.err.println(deferror.toString());
            }
            if (DBDEFInfo.hasINDEX(dbdef, indexType)) {
                this.logger.debug((Object)"Trying: ", (Object)dbdef.getTITLE());
                Enumeration fields = dbdef.fields();
                while (fields.hasMoreElements()) {
                    FIELD field = (FIELD)fields.nextElement();
                    String mime = field.getMIMETYPE();
                    String ftype = field.getTYPE();
                    if ((mime.equals("chemical/x-mdl-mol") || mime.equals("chemical/x-pdb") || mime.equals("chemical/x-cml")) && (ftype.equals("3DSTRUCTURE") || ftype.equals("2DSTRUCTURE"))) {
                        this.logger.info((Object)"Accepted: ", (Object)field.getMIMETYPE(), (Object)",", (Object)field.getTYPE());
                        Enumeration indices = field.getINDEX();
                        while (indices.hasMoreElements()) {
                            INDEX ind = (INDEX)indices.nextElement();
                            if (!ind.getTYPE().equals(indexType)) continue;
                            String url = dbdef.getURL() + ind.getACCESS_PREFIX() + index + ind.getACCESS_SUFFIX();
                            this.logger.debug((Object)"Adding to resolved links: ", (Object)url);
                            try {
                                links.add(new DADMLResult(new URL(url), field));
                            }
                            catch (MalformedURLException exception) {
                                this.logger.error((Object)"Malformed URL: ", (Object)exception.getMessage());
                                this.logger.debug((Object)exception);
                            }
                        }
                        continue;
                    }
                    this.logger.info((Object)"Rejected: ", (Object)field.getMIMETYPE(), (Object)",", (Object)field.getTYPE());
                }
                continue;
            }
            this.logger.warn((Object)"Database does not have indexType: ", (Object)indexType);
        }
        return links;
    }

    private Molecule downloadURL(URL resource) {
        Molecule molecule = new Molecule();
        this.logger.debug((Object)"Downloading from URL: ", (Object)resource);
        try {
            URLConnection connection = resource.openConnection();
            BufferedReader bufReader = new BufferedReader(new InputStreamReader(connection.getInputStream()));
            ChemObjectReader reader = new ReaderFactory().createReader((Reader)bufReader);
            ChemFile chemFile = (ChemFile)reader.read((ChemObject)new ChemFile());
            this.logger.debug((Object)"#sequences: ", chemFile.getChemSequenceCount());
            ChemSequence chemSequence = chemFile.getChemSequence(0);
            this.logger.debug((Object)"#models in sequence: ", chemSequence.getChemModelCount());
            ChemModel chemModel = chemSequence.getChemModel(0);
            SetOfMolecules moleculeSet = chemModel.getSetOfMolecules();
            this.logger.debug((Object)"#mols in model: ", moleculeSet.getMoleculeCount());
            molecule = moleculeSet.getMolecule(0);
        }
        catch (UnsupportedChemObjectException exception) {
            this.logger.error((Object)"Unsupported ChemObject type: ", (Object)exception.getMessage());
            this.logger.debug((Object)exception);
        }
        catch (FileNotFoundException exception) {
            this.logger.error((Object)"File not found: ", (Object)exception.getMessage());
            this.logger.debug((Object)exception);
        }
        catch (Exception exception) {
            this.logger.error((Object)exception.getMessage());
            this.logger.debug((Object)exception);
        }
        return molecule;
    }

    public void close() throws IOException {
    }
}

